
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Dale
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Peggy
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bill
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Ringo

    # Objective function
    model.setObjective(3*x0 + 9*x1 + 2*x2 + 2*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x0 <= 264)
    model.addConstr(13*x0 <= 237)
    model.addConstr(6*x1 <= 264)
    model.addConstr(9*x1 <= 237)
    model.addConstr(21*x2 <= 264)
    model.addConstr(8*x2 <= 237)
    model.addConstr(18*x3 <= 264)
    model.addConstr(12*x3 <= 237)
    model.addConstr(6*x1 + 18*x3 >= 36)
    model.addConstr(6*x0 + 21*x2 >= 33)
    model.addConstr(6*x1 + 21*x2 >= 62)
    model.addConstr(21*x2 + 18*x3 >= 60)
    model.addConstr(6*x0 + 6*x1 + 21*x2 >= 53)
    model.addConstr(6*x0 + 21*x2 + 18*x3 >= 53)
    model.addConstr(6*x0 + 6*x1 + 21*x2 >= 42)
    model.addConstr(6*x0 + 21*x2 + 18*x3 >= 42)
    model.addConstr(9*x1 + 8*x2 >= 24)
    model.addConstr(13*x0 + 12*x3 >= 33)
    model.addConstr(9*x1 + 12*x3 >= 48)
    model.addConstr(13*x0 + 8*x2 >= 31)
    model.addConstr(8*x2 + 12*x3 >= 27)
    model.addConstr(6*x0 + 18*x3 <= 185)
    model.addConstr(21*x2 + 18*x3 <= 217)
    model.addConstr(6*x1 + 21*x2 <= 95)
    model.addConstr(6*x0 + 6*x1 + 21*x2 + 18*x3 <= 95)
    model.addConstr(13*x0 + 8*x2 <= 237)
    model.addConstr(8*x2 + 12*x3 <= 145)
    model.addConstr(13*x0 + 12*x3 <= 128)
    model.addConstr(13*x0 + 9*x1 + 8*x2 + 12*x3 <= 128)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Dale: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Bill: ", x2.varValue)
        print("Hours worked by Ringo: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
