
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")


# Set objective function
m.setObjective(6*vitamin_k + 9*vitamin_b12 + 7*vitamin_b2 + 1*vitamin_b9 + 6*vitamin_b4, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(14*vitamin_b12 + 13*vitamin_b2 >= 22)
m.addConstr(13*vitamin_b2 + 12*vitamin_b4 >= 20)
m.addConstr(14*vitamin_b12 + 12*vitamin_b4 >= 28)
m.addConstr(9*vitamin_k + 12*vitamin_b4 >= 20)
m.addConstr(3*vitamin_b9 + 5*vitamin_b4 >= 13)
m.addConstr(9*vitamin_k + 3*vitamin_b9 >= 5)
m.addConstr(13*vitamin_b12 + 5*vitamin_b4 >= 5)
m.addConstr(13*vitamin_b12 + 3*vitamin_b9 >= 8)
m.addConstr(7*vitamin_b2 + 5*vitamin_b4 >= 12)
m.addConstr(9*vitamin_k + 13*vitamin_b12 >= 6)
m.addConstr(9*vitamin_k + 7*vitamin_b2 >= 9)
m.addConstr(7*vitamin_b2 + 3*vitamin_b9 >= 11)

# ... (rest of the constraints from the JSON, following the same pattern)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

