
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_pies")
kale_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="kale_salads")
cantaloupes = m.addVar(lb=0, vtype=GRB.INTEGER, name="cantaloupes")


# Set objective function
m.setObjective(cherry_pies * kale_salads + 8 * kale_salads**2 + 2 * kale_salads * cantaloupes + 6 * cantaloupes**2 + 6 * cherry_pies + 3 * kale_salads + 7 * cantaloupes, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*cherry_pies + 15*kale_salads + 17*cantaloupes >= 41)
m.addConstr(12*cherry_pies + 4*kale_salads + 16*cantaloupes >= 39)
m.addConstr(4*kale_salads + 16*cantaloupes >= 31)
m.addConstr(12*cherry_pies + 16*cantaloupes >= 39)
m.addConstr(12*cherry_pies + 4*kale_salads + 16*cantaloupes >= 39)
m.addConstr(1*cherry_pies + 11*cantaloupes >= 10)
m.addConstr(11*kale_salads**2 + 11*cantaloupes**2 >= 28)
m.addConstr(1*cherry_pies + 11*kale_salads >= 16)
m.addConstr(1*cherry_pies**2 + 11*kale_salads**2 + 11*cantaloupes**2 >= 19)
m.addConstr(1*cherry_pies + 11*kale_salads + 11*cantaloupes >= 19)
m.addConstr(17*cherry_pies**2 + 7*kale_salads**2 >= 36)
m.addConstr(7*kale_salads + 7*cantaloupes >= 47)
m.addConstr(17*cherry_pies**2 + 7*cantaloupes**2 >= 48)
m.addConstr(17*cherry_pies + 7*kale_salads + 7*cantaloupes >= 48)
m.addConstr(11*cherry_pies + 9*kale_salads >= 32)
m.addConstr(11*cherry_pies**2 + 5*cantaloupes**2 >= 26)
m.addConstr(11*cherry_pies + 9*kale_salads + 5*cantaloupes >= 26)
m.addConstr(10*cherry_pies - 4*kale_salads >= 0)
m.addConstr(1*cherry_pies + 11*cantaloupes <= 75)
m.addConstr(1*cherry_pies + 11*kale_salads <= 72)
m.addConstr(1*cherry_pies + 11*kale_salads + 11*cantaloupes <= 40)
m.addConstr(7*kale_salads + 7*cantaloupes <= 86)

m.addConstr(5*cherry_pies + 15*kale_salads + 17*cantaloupes <= 263)
m.addConstr(12*cherry_pies + 4*kale_salads + 16*cantaloupes <= 134)
m.addConstr(1*cherry_pies + 11*kale_salads + 11*cantaloupes <= 86)
m.addConstr(17*cherry_pies + 7*kale_salads + 7*cantaloupes <= 218)
m.addConstr(11*cherry_pies + 9*kale_salads + 5*cantaloupes <= 102)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

