
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="cherry_pies", lb=0, ub=None, type=gurobi.GRB.CONTINUOUS)
x1 = m.addVar(name="kale_salads", lb=0, ub=None, type=gurobi.GRB.INTEGER)
x2 = m.addVar(name="cantaloupes", lb=0, ub=None, type=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(1 * x0 * x1 + 8 * x1**2 + 2 * x1 * x2 + 6 * x2**2 + 6 * x0 + 3 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * x0 >= 41, name="iron_cherry")
m.addConstr(5 * x0 + 15 * x1 + 17 * x2 >= 41, name="total_iron")
m.addConstr(4 * x1 + 16 * x2 >= 31, name="tastiness_kale_cant")
m.addConstr(12 * x0 + 16 * x2 >= 39, name="tastiness_cherry_cant")
m.addConstr(12 * x0 + 4 * x1 + 16 * x2 >= 39, name="total_tastiness")
m.addConstr(x0 + 11 * x2 >= 10, name="spend_cherry_cant")
m.addConstr(11 * x1**2 + 11 * x2**2 >= 28, name="spend_kale_cant_squared")
m.addConstr(x0 + 11 * x1 >= 16, name="spend_cherry_kale")
m.addConstr(x0**2 + x1**2 + x2**2 >= 19, name="spend_squared")
m.addConstr(x0 + 11 * x1 + 11 * x2 >= 19, name="spend_total")
m.addConstr(17 * x0**2 + 7 * x1**2 >= 36, name="fat_cherry_kale_squared")
m.addConstr(7 * x1 + 7 * x2 >= 47, name="fat_kale_cant")
m.addConstr(17 * x0**2 + 7 * x2**2 >= 48, name="fat_cherry_cant_squared")
m.addConstr(17 * x0 + 7 * x1 + 7 * x2 >= 48, name="total_fat")
m.addConstr(11 * x0 + 9 * x1 >= 32, name="carbohydrates_cherry_kale")
m.addConstr(11 * x0**2 + 5 * x2**2 >= 26, name="carbohydrates_cherry_cant_squared")
m.addConstr(11 * x0 + 9 * x1 + 5 * x2 >= 26, name="total_carbohydrates")
m.addConstr(10 * x0 - 4 * x1 >= 0, name="cherry_kale_relation")
m.addConstr(x0 + 11 * x2 <= 75, name="spend_cherry_cant_max")
m.addConstr(x0 + 11 * x1 <= 72, name="spend_cherry_kale_max")
m.addConstr(x0 + 11 * x1 + 11 * x2 <= 40, name="spend_total_max")
m.addConstr(7 * x1 + 7 * x2 <= 86, name="fat_kale_cant_max")

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Cherry Pies: ", x0.varValue)
    print("Kale Salads: ", x1.varValue)
    print("Cantaloupes: ", x2.varValue)
else:
    print("No solution found")
