
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize_Work_Hours")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_Bill")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_Peggy")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_Bobby")


    # Set objective function
    model.setObjective(4*x0 + 9*x1 + 9*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*x1 + 2*x2 >= 39, "c1")
    model.addConstr(3*x0 + 2*x2 >= 73, "c2")
    model.addConstr(3*x0 + 12*x1 + 2*x2 >= 64, "c3")
    model.addConstr(15*x1 + 24*x2 >= 90, "c4")
    model.addConstr(5*x0 + 15*x1 >= 33, "c5")
    model.addConstr(18*x0 + 18*x2 >= 16, "c6")
    model.addConstr(6*x1 + 18*x2 >= 32, "c7")
    model.addConstr(6*x1 + 15*x2 >= 74, "c8")
    model.addConstr(24*x1 + 9*x2 >= 68, "c9")
    model.addConstr(19*x0 + 24*x1 >= 27, "c10")
    model.addConstr(6*x1 - 4*x2 >= 0, "c11")
    model.addConstr(3*x0 - x2 >= 0, "c12")
    model.addConstr(-2*x0 + 3*x1 >= 0, "c13")
    model.addConstr(3*x0 + 12*x1 <= 143, "c14")
    model.addConstr(19*x0 + 24*x1 <= 137, "c15")
    model.addConstr(19*x0 + 9*x2 <= 114, "c16")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
