
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=0)
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x2 = m.addVar(name="hours_worked_by_Bobby", lb=0)

# Define the objective function
m.setObjective(4*x0 + 9*x1 + 9*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 <= 260)
m.addConstr(5*x0 <= 271)
m.addConstr(18*x0 <= 103)
m.addConstr(26*x0 <= 288)
m.addConstr(19*x0 <= 248)

m.addConstr(12*x1 <= 260)
m.addConstr(15*x1 <= 271)
m.addConstr(6*x1 <= 103)
m.addConstr(6*x1 <= 288)
m.addConstr(24*x1 <= 248)

m.addConstr(2*x2 <= 260)
m.addConstr(24*x2 <= 271)
m.addConstr(18*x2 <= 103)
m.addConstr(15*x2 <= 288)
m.addConstr(9*x2 <= 248)

m.addConstr(12*x1 + 2*x2 >= 39)
m.addConstr(3*x0 + 2*x2 >= 73)
m.addConstr(3*x0 + 12*x1 + 2*x2 >= 64)
m.addConstr(5*x0 + 15*x1 >= 33)
m.addConstr(5*x0 + 15*x1 + 24*x2 >= 33)
m.addConstr(18*x0 + 18*x2 >= 16)
m.addConstr(6*x1 + 18*x2 >= 32)
m.addConstr(18*x0 + 6*x1 + 18*x2 >= 32)
m.addConstr(6*x1 + 15*x2 >= 74)
m.addConstr(26*x0 + 6*x1 + 15*x2 >= 74)
m.addConstr(24*x1 + 9*x2 >= 68)
m.addConstr(19*x0 + 24*x1 >= 27)
m.addConstr(19*x0 + 24*x1 + 9*x2 >= 27)
m.addConstr(6*x1 - 4*x2 >= 0)
m.addConstr(3*x0 - x2 >= 0)
m.addConstr(-2*x0 + 3*x1 >= 0)
m.addConstr(3*x0 + 12*x1 <= 143)
m.addConstr(19*x0 + 24*x1 <= 137)
m.addConstr(19*x0 + 9*x2 <= 114)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {x0.varValue}")
    print(f"Hours worked by Peggy: {x1.varValue}")
    print(f"Hours worked by Bobby: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
