
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B6
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B7
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # grams of protein
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of zinc


    # Set objective function
    m.setObjective(6.77 * x0 + 6.7 * x1 + 8.2 * x2 + 9.77 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16.76 * x0 + 13.75 * x1 >= 83)
    m.addConstr(16.76 * x0 + 3.76 * x2 >= 79)
    m.addConstr(13.75 * x1 + 3.76 * x2 >= 61)
    m.addConstr(16.76 * x0 + 12.02 * x3 >= 80)
    m.addConstr(13.75 * x1 + 12.02 * x3 >= 42)
    m.addConstr(3.76 * x2 + 12.02 * x3 >= 36)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 3.76 * x2 >= 46)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 12.02 * x3 >= 46)
    m.addConstr(16.76 * x0 + 3.76 * x2 + 12.02 * x3 >= 46)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 3.76 * x2 >= 81)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 12.02 * x3 >= 81)
    m.addConstr(16.76 * x0 + 3.76 * x2 + 12.02 * x3 >= 81)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 3.76 * x2 >= 62)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 12.02 * x3 >= 62)
    m.addConstr(16.76 * x0 + 3.76 * x2 + 12.02 * x3 >= 62)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 3.76 * x2 + 12.02 * x3 >= 62)
    m.addConstr(1.28 * x1 + 10.19 * x2 >= 43)
    m.addConstr(17.28 * x0 + 10.19 * x2 + 2.48 * x3 >= 70)
    m.addConstr(17.28 * x0 + 1.28 * x1 + 10.19 * x2 + 2.48 * x3 >= 70)
    m.addConstr(5 * x1 - 8 * x2 >= 0)
    m.addConstr(-3 * x2 + 4 * x3 >= 0)
    m.addConstr(13.75 * x1 + 3.76 * x2 + 12.02 * x3 <= 357)
    m.addConstr(16.76 * x0 + 13.75 * x1 + 3.76 * x2 <= 219)
    m.addConstr(17.28 * x0 + 2.48 * x3 <= 113)
    m.addConstr(17.28 * x0 + 10.19 * x2 <= 311)
    m.addConstr(1.28 * x1 + 10.19 * x2 <= 310)
    m.addConstr(10.19 * x2 + 2.48 * x3 <= 246)
    m.addConstr(17.28 * x0 + 1.28 * x1 <= 302)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
