
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")

    # Set objective function
    m.setObjective(3*x0 + 4*x1 + 9*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 8*x1 + 14*x2 <= 123, "kidney_support_ub")
    m.addConstr(7*x0 + 15*x1 + 16*x2 <= 162, "energy_stability_ub")
    m.addConstr(8*x1 + 14*x2 >= 39, "kidney_support_a_fat_lb")
    m.addConstr(6*x0 + 14*x2 >= 30, "kidney_support_c_fat_lb")
    m.addConstr(8*x1 + 14*x2 <= 88, "kidney_support_a_fat_ub")
    m.addConstr(6*x0 + 8*x1 + 14*x2 <= 88, "kidney_support_all_ub")
    m.addConstr(15*x1 + 16*x2 <= 90, "energy_stability_a_fat_ub")
    m.addConstr(7*x0 + 16*x2 <= 108, "energy_stability_c_fat_ub")
    m.addConstr(7*x0 + 15*x1 + 16*x2 <= 108, "energy_stability_all_ub")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin C: %g' % x0.x)
        print('Vitamin A: %g' % x1.x)
        print('Fat: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
