
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_C", lb=0)
    x1 = model.addVar(name="milligrams_of_vitamin_A", lb=0)
    x2 = model.addVar(name="grams_of_fat", lb=0)

    # Define the objective function
    model.setObjective(3*x0 + 4*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6*x0 <= 123)
    model.addConstr(7*x0 <= 162)
    model.addConstr(8*x1 <= 123)
    model.addConstr(15*x1 <= 162)
    model.addConstr(14*x2 <= 123)
    model.addConstr(8*x1 + 14*x2 >= 39)
    model.addConstr(6*x0 + 14*x2 >= 30)
    model.addConstr(8*x1 + 14*x2 <= 88)
    model.addConstr(6*x0 + 8*x1 + 14*x2 <= 88)
    model.addConstr(15*x1 + 16*x2 <= 90)
    model.addConstr(7*x0 + 16*x2 <= 108)
    model.addConstr(7*x0 + 15*x1 + 16*x2 <= 108)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x0.varValue}")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Grams of fat: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
