
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Work_Hours")

# Create variables
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")


# Set objective function
model.setObjective(9.09 * bill + 3.98 * dale + 5.26 * peggy + 8.66 * jean, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * bill + 1 * dale >= 6)
model.addConstr(3 * bill + 1 * dale + 2 * peggy + 2 * jean >= 6)
model.addConstr(4 * bill + 5 * peggy >= 9)
model.addConstr(4 * bill + 5 * dale >= 13)
model.addConstr(4 * bill + 5 * dale + 5 * peggy + 5 * jean >= 13)
model.addConstr(1 * bill + 3 * peggy >= 12)
model.addConstr(4 * dale + 3 * peggy >= 10)
model.addConstr(3 * peggy + 1 * jean >= 8)
model.addConstr(4 * dale + 1 * jean >= 8)
model.addConstr(1 * bill + 1 * jean >= 11)
model.addConstr(1 * bill + 4 * dale >= 7)
model.addConstr(1 * bill + 4 * dale + 3 * peggy + 1 * jean >= 7)
model.addConstr(3 * dale + 2 * jean >= 8)
model.addConstr(3 * bill + 4 * peggy >= 11)
model.addConstr(3 * bill + 3 * dale + 4 * peggy >= 5)
model.addConstr(3 * bill + 4 * peggy + 2 * jean >= 5)
model.addConstr(3 * bill + 3 * dale + 4 * peggy >= 8)
model.addConstr(3 * bill + 4 * peggy + 2 * jean >= 8)
model.addConstr(3 * bill + 3 * dale + 4 * peggy + 2 * jean >= 8)
model.addConstr(-9 * dale + 1 * jean >= 0)
model.addConstr(9 * bill - 10 * dale >= 0)
model.addConstr(3 * bill + 2 * peggy <= 28)
model.addConstr(3 * bill + 2 * jean <= 15)
model.addConstr(3 * bill + 2 * peggy + 2 * jean <= 13)
model.addConstr(3 * bill + 1 * dale + 2 * peggy <= 32)
model.addConstr(1 * bill + 1 * jean <= 81)
model.addConstr(3 * peggy + 1 * jean <= 84)
model.addConstr(1 * bill + 3 * peggy <= 65)
model.addConstr(4 * dale + 3 * peggy <= 46)
model.addConstr(3 * bill + 3 * dale + 4 * peggy <= 38)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

