
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Bill
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Dale
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Peggy
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Jean

    # Objective function
    model.setObjective(9.09 * x0 + 3.98 * x1 + 5.26 * x2 + 8.66 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x0 >= 6)
    model.addConstr(3 * x0 + x1 + 2 * x2 + 2 * x3 >= 6)
    model.addConstr(4 * x0 + 5 * x2 >= 9)
    model.addConstr(4 * x0 + 5 * x1 >= 13)
    model.addConstr(4 * x0 + 5 * x1 + 5 * x2 + 5 * x3 >= 13)
    model.addConstr(x0 + 3 * x2 >= 12)
    model.addConstr(4 * x1 + 3 * x2 >= 10)
    model.addConstr(3 * x2 + x3 >= 8)
    model.addConstr(4 * x1 + x3 >= 8)
    model.addConstr(x0 + x3 >= 11)
    model.addConstr(x0 + 4 * x1 >= 7)
    model.addConstr(x0 + 4 * x1 + 3 * x2 + x3 >= 7)
    model.addConstr(3 * x1 + 2 * x3 >= 8)
    model.addConstr(3 * x0 + 4 * x2 >= 11)
    model.addConstr(3 * x0 + x1 + 4 * x2 >= 5)
    model.addConstr(3 * x0 + 4 * x2 + 2 * x3 >= 5)
    model.addConstr(3 * x0 + x1 + 4 * x2 >= 8)
    model.addConstr(3 * x0 + x1 + 4 * x2 + 2 * x3 >= 8)
    model.addConstr(-9 * x1 + x3 >= 0)
    model.addConstr(9 * x0 - 10 * x1 >= 0)
    model.addConstr(3 * x0 + 2 * x2 <= 28)
    model.addConstr(3 * x0 + 2 * x3 <= 15)
    model.addConstr(3 * x0 + 2 * x2 + 2 * x3 <= 13)
    model.addConstr(3 * x0 + x1 + 2 * x2 <= 32)
    model.addConstr(x0 + x3 <= 81)
    model.addConstr(3 * x2 + x3 <= 84)
    model.addConstr(x0 + 3 * x2 <= 65)
    model.addConstr(4 * x1 + 3 * x2 <= 46)
    model.addConstr(3 * x0 + x1 + 4 * x2 <= 38)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No solution found")

optimization_problem()
