
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of zinc
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # milligrams of vitamin E
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B6


    # Set objective function
    m.setObjective(3*x0**2 + 2*x0*x1 + 5*x0*x2 + 4*x1**2 + 4*x2**2 + 3*x0 + 2*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15*x0 + 15*x1 >= 49, "c0")
    m.addConstr(15*x1**2 + 20*x2**2 >= 106, "c1")
    m.addConstr(15*x0 + 15*x1 + 20*x2 >= 106, "c2")
    m.addConstr(19*x0 + 8*x1 >= 66, "c3")
    m.addConstr(8*x1**2 + 9*x2**2 >= 46, "c4")
    m.addConstr(19*x0 + 8*x1 + 9*x2 >= 46, "c5")
    m.addConstr(3*x1 + 16*x2 >= 37, "c6")
    m.addConstr(13*x0 + 16*x2 >= 71, "c7")
    m.addConstr(13*x0 + 3*x1 + 16*x2 >= 71, "c8")
    m.addConstr(10*x0**2 - 3*x1**2 >= 0, "c9")
    m.addConstr(8*x0 - 8*x2 >= 0, "c10")
    m.addConstr(15*x0 + 20*x2 <= 150, "c11")
    m.addConstr(15*x1 + 20*x2 <= 270, "c12")
    m.addConstr(15*x0 + 15*x1 <= 320, "c13")
    m.addConstr(8*x1 + 9*x2 <= 94, "c14")
    m.addConstr(19*x0 + 9*x2 <= 205, "c15")
    m.addConstr(13*x0**2 + 16*x2**2 <= 263, "c16")
    m.addConstr(3*x1 + 16*x2 <= 121, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Other optimization status code:', m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
