
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='milligrams_of_zinc', vtype='I')  # Integer
x1 = model.addVar(name='milligrams_of_vitamin_E', vtype='I')  # Integer
x2 = model.addVar(name='milligrams_of_vitamin_B6')  # Continuous

# Define the objective function
model.setObjective(3*x0**2 + 2*x0*x1 + 5*x0*x2 + 4*x1**2 + 4*x2**2 + 3*x0 + 2*x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(15*x0 <= 320)
model.addConstr(19*x0 <= 222)
model.addConstr(13*x0 <= 285)
model.addConstr(15*x1 <= 320)
model.addConstr(8*x1 <= 222)
model.addConstr(3*x1 <= 285)
model.addConstr(20*x2 <= 320)
model.addConstr(9*x2 <= 222)
model.addConstr(16*x2 <= 285)
model.addConstr(15*x0 + 15*x1 >= 49)
model.addConstr(15**2*x1 + 20**2*x2 >= 106)
model.addConstr(15*x0 + 15*x1 + 20*x2 >= 106)
model.addConstr(19*x0 + 8*x1 >= 66)
model.addConstr(8**2*x1 + 9**2*x2 >= 46)
model.addConstr(19*x0 + 8*x1 + 9*x2 >= 46)
model.addConstr(3*x1 + 16*x2 >= 37)
model.addConstr(13*x0 + 16*x2 >= 71)
model.addConstr(13*x0 + 3*x1 + 16*x2 >= 71)
model.addConstr(10*x0**2 - 3*x1**2 >= 0)
model.addConstr(8*x0 - 8*x2 >= 0)
model.addConstr(15*x0 + 20*x2 <= 150)
model.addConstr(15*x1 + 20*x2 <= 270)
model.addConstr(15*x0 + 15*x1 <= 320)
model.addConstr(8*x1 + 9*x2 <= 94)
model.addConstr(19*x0 + 9*x2 <= 205)
model.addConstr(13**2*x0 + 16**2*x2 <= 263)
model.addConstr(3*x1 + 16*x2 <= 121)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('Milligrams of zinc: ', x0.varValue)
    print('Milligrams of vitamin E: ', x1.varValue)
    print('Milligrams of vitamin B6: ', x2.varValue)
else:
    print('No solution found')
