
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="bowls of instant ramen")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cherry pies")
    x2 = m.addVar(vtype=GRB.INTEGER, name="blueberry pies")


    # Set objective function
    m.setObjective(2*x0 + 9*x1 + 5*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x1 + 9*x2 >= 53, "c1")
    m.addConstr(11*x0 + 9*x2 >= 31, "c2")
    m.addConstr(11*x0 + 7*x1 + 9*x2 >= 31, "c3")
    m.addConstr(4*x1 - 9*x2 >= 0, "c4")
    m.addConstr(11*x0 + 7*x1 + 9*x2 <= 120, "c5")
    m.addConstr(11*x0 + 7*x1 + 9*x2 <= 261, "c6")  # Healthiness rating constraint


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bowls of instant ramen: %g' % x0.x)
        print('cherry pies: %g' % x1.x)
        print('blueberry pies: %g' % x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
