
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="bowls_of_instant_ramem")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cherry_pies")
x3 = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Set the objective function
m.setObjective(2*x1 + 9*x2 + 5*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x2 + 9*x3 >= 53, "healthiness_rating_cherry_blueberry")
m.addConstr(11*x1 + 9*x3 >= 31, "healthiness_rating_ramem_blueberry")
m.addConstr(11*x1 + 7*x2 + 9*x3 >= 31, "total_healthiness_rating_min")
m.addConstr(4*x2 - 9*x3 >= 0, "cherry_pies_constraint")
m.addConstr(11*x1 + 7*x2 + 9*x3 <= 120, "total_healthiness_rating_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Bowls of instant ramen:", x1.x)
    print("Cherry pies:", x2.x)
    print("Blueberry pies:", x3.x)
else:
    print("No optimal solution found")
