
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bowls_of_instant_ramen", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cherry_pies")
    x3 = model.addVar(name="blueberry_pies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(2*x1 + 9*x2 + 5*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7*x2 + 9*x3 >= 53)
    model.addConstr(11*x1 + 9*x3 >= 31)
    model.addConstr(11*x1 + 7*x2 + 9*x3 >= 31)
    model.addConstr(4*x2 - 9*x3 >= 0)
    model.addConstr(11*x1 + 7*x2 + 9*x3 <= 120)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"bowls of instant ramen: {x1.varValue}")
        print(f"cherry pies: {x2.varValue}")
        print(f"blueberry pies: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
