
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hamburgers")
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
chicken = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken")

# Set objective function
m.setObjective(4.85 * kiwis + 5.61 * hamburgers + 8.82 * bacon + 6.75 * chicken, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * hamburgers + 5 * chicken >= 26)
m.addConstr(8 * kiwis + 9 * bacon >= 27)
m.addConstr(8 * hamburgers + 9 * bacon >= 25)
m.addConstr(8 * kiwis + 8 * hamburgers >= 14)
m.addConstr(5 * bacon + 1 * chicken >= 36)
m.addConstr(7 * hamburgers + 5 * bacon >= 34)
m.addConstr(2 * kiwis + 5 * bacon + 1 * chicken >= 34)
m.addConstr(7 * hamburgers + 5 * bacon + 1 * chicken >= 34)
m.addConstr(2 * kiwis + 7 * hamburgers + 5 * bacon >= 34)
m.addConstr(2 * kiwis + 5 * bacon + 1 * chicken >= 26)
m.addConstr(7 * hamburgers + 5 * bacon + 1 * chicken >= 26)
m.addConstr(2 * kiwis + 7 * hamburgers + 5 * bacon >= 26)
m.addConstr(2 * kiwis + 5 * bacon + 1 * chicken >= 19)
m.addConstr(7 * hamburgers + 5 * bacon + 1 * chicken >= 19)
m.addConstr(2 * kiwis + 7 * hamburgers + 5 * bacon >= 19)
m.addConstr(8 * kiwis + 9 * bacon <= 74)
m.addConstr(8 * kiwis + 5 * chicken <= 104)
m.addConstr(8 * hamburgers + 9 * bacon + 5 * chicken <= 93)
m.addConstr(8 * kiwis + 8 * hamburgers + 9 * bacon + 5 * chicken <= 93)
m.addConstr(7 * hamburgers + 5 * bacon <= 113)
m.addConstr(2 * kiwis + 7 * hamburgers + 1 * chicken <= 93)
m.addConstr(2 * kiwis + 5 * bacon + 1 * chicken <= 46)
m.addConstr(2 * kiwis + 7 * hamburgers + 5 * bacon + 1 * chicken <= 46)
m.addConstr(8 * kiwis + 8 * hamburgers + 9 * bacon + 5 * chicken <= 123)
m.addConstr(2 * kiwis + 7 * hamburgers + 5 * bacon + 1 * chicken <= 155)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

