
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="kiwis", lb=0, ub=None)
x1 = m.addVar(name="hamburgers", lb=0, ub=None, integrality=1)
x2 = m.addVar(name="strips of bacon", lb=0, ub=None)
x3 = m.addVar(name="chicken breasts", lb=0, ub=None, integrality=1)

# Define the objective function
m.setObjective(4.85 * x0 + 5.61 * x1 + 8.82 * x2 + 6.75 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * x0 <= 123)
m.addConstr(8 * x1 <= 123)
m.addConstr(9 * x2 <= 123)
m.addConstr(5 * x3 <= 123)
m.addConstr(2 * x0 + 7 * x1 + 5 * x2 + x3 <= 155)
m.addConstr(8 * x1 + 5 * x3 >= 26)
m.addConstr(8 * x0 + 9 * x2 >= 27)
m.addConstr(8 * x1 + 9 * x2 >= 25)
m.addConstr(8 * x0 + 8 * x1 >= 14)
m.addConstr(5 * x2 + x3 >= 36)
m.addConstr(7 * x1 + 5 * x2 >= 34)
m.addConstr(2 * x0 + 5 * x2 + x3 >= 34)
m.addConstr(7 * x1 + 5 * x2 + x3 >= 34)
m.addConstr(2 * x0 + 7 * x1 + 5 * x2 >= 34)
m.addConstr(2 * x0 + 5 * x2 + x3 >= 26)
m.addConstr(7 * x1 + 5 * x2 + x3 >= 26)
m.addConstr(2 * x0 + 7 * x1 + 5 * x2 >= 26)
m.addConstr(2 * x0 + 5 * x2 + x3 >= 19)
m.addConstr(7 * x1 + 5 * x2 + x3 >= 19)
m.addConstr(2 * x0 + 7 * x1 + 5 * x2 >= 19)
m.addConstr(8 * x0 + 9 * x2 <= 74)
m.addConstr(8 * x0 + 5 * x3 <= 104)
m.addConstr(8 * x1 + 9 * x2 + 5 * x3 <= 93)
m.addConstr(8 * x0 + 8 * x1 + 9 * x2 + 5 * x3 <= 93)
m.addConstr(7 * x1 + 5 * x2 <= 113)
m.addConstr(2 * x0 + 7 * x1 + x3 <= 93)
m.addConstr(2 * x0 + 5 * x2 + x3 <= 46)
m.addConstr(2 * x0 + 7 * x1 + 5 * x2 + x3 <= 46)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Kiwis: ", x0.varValue)
    print("Hamburgers: ", x1.varValue)
    print("Strips of bacon: ", x2.varValue)
    print("Chicken breasts: ", x3.varValue)
else:
    print("The model is infeasible")
