
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_cost")

# Create variables
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
paper_towel_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")


# Set objective function
m.setObjective(8 * lightbulbs + 9 * paper_towel_rolls + 6 * cookies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * lightbulbs + 17 * paper_towel_rolls + 8 * cookies <= 103, "budget")
m.addConstr(16 * lightbulbs + 17 * paper_towel_rolls >= 34, "lightbulbs_paper_towel_rolls_min_cost")
m.addConstr(16 * lightbulbs + 8 * cookies >= 16, "lightbulbs_cookies_min_cost")
m.addConstr(16 * lightbulbs + 17 * paper_towel_rolls + 8 * cookies >= 16, "total_min_cost")
m.addConstr(-6 * lightbulbs + 6 * paper_towel_rolls >= 0, "lightbulbs_paper_towel_rolls_relation")
m.addConstr(5 * lightbulbs - 8 * cookies >= 0, "lightbulbs_cookies_relation")
m.addConstr(2 * paper_towel_rolls - 9 * cookies >= 0, "paper_towel_rolls_cookies_relation")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('lightbulbs:', lightbulbs.x)
    print('paper_towel_rolls:', paper_towel_rolls.x)
    print('cookies:', cookies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

