
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")
x2 = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
x3 = m.addVar(vtype=GRB.INTEGER, name="cookies")

# Set the objective function
m.setObjective(8*x1 + 9*x2 + 6*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x1 + 17*x2 >= 34, "constraint_1")
m.addConstr(16*x1 + 8*x3 >= 16, "constraint_2")
m.addConstr(16*x1 + 17*x2 + 8*x3 >= 16, "constraint_3")
m.addConstr(-6*x1 + 6*x2 >= 0, "constraint_4")
m.addConstr(5*x1 - 8*x3 >= 0, "constraint_5")
m.addConstr(2*x2 - 9*x3 >= 0, "constraint_6")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("lightbulbs:", x1.x)
    print("paper_towel_rolls:", x2.x)
    print("cookies:", x3.x)
else:
    print("No optimal solution found.")
