
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='lightbulbs', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='paper towel rolls', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='cookies', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8 * x1 + 9 * x2 + 6 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16 * x1 + 17 * x2 >= 34)
    model.addConstr(16 * x1 + 8 * x3 >= 16)
    model.addConstr(16 * x1 + 17 * x2 + 8 * x3 >= 16)
    model.addConstr(-6 * x1 + 6 * x2 >= 0)
    model.addConstr(5 * x1 - 8 * x3 >= 0)
    model.addConstr(2 * x2 - 9 * x3 >= 0)

    # Set dollar cost constraint 
    model.addConstr(16 * x1 + 17 * x2 <= 103)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'lightbulbs: {x1.varValue}')
        print(f'paper towel rolls: {x2.varValue}')
        print(f'cookies: {x3.varValue}')
        print(f'Objective: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
