
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(x0**2 + 4*x1**2 + 3*x1*x2 + 6*x1*x3 + 3*x2**2, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x0 + 15*x1 + 15*x2 + 11*x3 <= 118, "c0")
m.addConstr(22*x0 + 7*x1 + 12*x2 + 25*x3 <= 432, "c1")
m.addConstr(15*x1**2 + 11*x3**2 >= 10, "c2")
m.addConstr(13*x0 + 15*x1 >= 19, "c3")
# ... (add all other constraints similarly)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

