
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="x1", lb=-float('inf'), ub=float('inf'))
x2 = model.addVar(name="x2", lb=-float('inf'), ub=float('inf'))
x3 = model.addVar(name="x3", lb=-float('inf'), ub=float('inf'))
x4 = model.addVar(name="x4", lb=-float('inf'), ub=float('inf'))

# Define the objective function
model.setObjective(1 * x1**2 + 4 * x2**2 + 3 * x2 * x3 + 6 * x2 * x4 + 3 * x3**2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(13 * x1 <= 118)
model.addConstr(22 * x1 <= 432)
model.addConstr(15 * x2 <= 118)
model.addConstr(7 * x2 <= 432)
model.addConstr(15 * x3 <= 118)
model.addConstr(12 * x3 <= 432)
model.addConstr(11 * x4 <= 118)
model.addConstr(25 * x4 <= 432)
model.addConstr(15 * x2**2 + 11 * x4**2 >= 10)
model.addConstr(13 * x1 + 15 * x2 >= 19)
model.addConstr(13 * x1 + 11 * x4 >= 19)
model.addConstr(13 * x1**2 + 15 * x3**2 + 11 * x4**2 >= 25)
model.addConstr(13 * x1 + 15 * x2 + 15 * x3 >= 25)
model.addConstr(15 * x2**2 + 15 * x3**2 + 11 * x4**2 >= 25)
model.addConstr(13 * x1 + 15 * x3 + 11 * x4 >= 19)
model.addConstr(13 * x1**2 + 15 * x2**2 + 15 * x3**2 >= 19)
model.addConstr(15 * x2 + 15 * x3 + 11 * x4 >= 19)
model.addConstr(13 * x1**2 + 15 * x3**2 + 11 * x4**2 >= 18)
model.addConstr(13 * x1 + 15 * x2 + 15 * x3 >= 18)
model.addConstr(15 * x2**2 + 15 * x3**2 + 11 * x4**2 >= 18)
model.addConstr(13 * x1 + 15 * x2 + 15 * x3 + 11 * x4 >= 18)
model.addConstr(7 * x2 + 25 * x4 >= 53)
model.addConstr(22 * x1 + 12 * x3 >= 42)
model.addConstr(22 * x1 + 7 * x2 >= 74)
model.addConstr(7 * x2 + 12 * x3 >= 48)
model.addConstr(22 * x1 + 12 * x3 + 25 * x4 >= 85)
model.addConstr(7 * x2 + 12 * x3 + 25 * x4 >= 85)
model.addConstr(22 * x1**2 + 12 * x3**2 + 25 * x4**2 >= 95)
model.addConstr(7 * x2 + 12 * x3 + 25 * x4 >= 95)
model.addConstr(22 * x1 + 7 * x2 + 12 * x3 + 25 * x4 >= 95)
model.addConstr(5 * x2 - 6 * x4 >= 0)
model.addConstr(13 * x1 + 15 * x2 <= 81)
model.addConstr(15 * x2 + 15 * x3 + 11 * x4 <= 82)
model.addConstr(12 * x3 + 25 * x4 <= 281)
model.addConstr(22 * x1 + 25 * x4 <= 397)
model.addConstr(22 * x1 + 7 * x2 <= 374)
model.addConstr(7 * x2 + 25 * x4 <= 377)
model.addConstr(7 * x2 + 12 * x3 <= 275)
model.addConstr(22 * x1 + 12 * x3 + 25 * x4 <= 135)
model.addConstr(7 * x2 + 12 * x3 + 25 * x4 <= 168)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible or unbounded.")
