
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_hours")

    # Create variables
    hank_hours = m.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
    paul_hours = m.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")


    # Set objective function
    m.setObjective(8 * hank_hours + 1 * paul_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.88 * hank_hours + 5.85 * paul_hours >= 37, "dollar_cost_min")
    m.addConstr(0.66 * hank_hours + 2.36 * paul_hours >= 40, "productivity_min")
    m.addConstr(10 * hank_hours - 10 * paul_hours >= 0, "hank_paul_relation")
    m.addConstr(1.88 * hank_hours + 5.85 * paul_hours <= 96, "dollar_cost_max")
    m.addConstr(0.66 * hank_hours + 2.36 * paul_hours <= 165, "productivity_max")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Hank Hours: %g' % hank_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

