
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")

# Set the objective function
m.setObjective(8*x1 + x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(1.88*x1 + 5.85*x2 >= 37, "dollar_cost_min")
m.addConstr(0.66*x1 + 2.36*x2 >= 40, "productivity_rating_min")
m.addConstr(10*x1 - 10*x2 >= 0, "balance_constraint")
m.addConstr(1.88*x1 + 5.85*x2 <= 96, "dollar_cost_max")
m.addConstr(0.66*x1 + 2.36*x2 <= 165, "productivity_rating_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
else:
    print("No optimal solution found")
