
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Hank', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_Paul', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8 * x1 + 1 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(1.88 * x1 + 5.85 * x2 >= 37)
    model.addConstr(0.66 * x1 + 2.36 * x2 >= 40)
    model.addConstr(10 * x1 - 10 * x2 >= 0)
    model.addConstr(1.88 * x1 + 5.85 * x2 <= 96)
    model.addConstr(0.66 * x1 + 2.36 * x2 <= 165)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Hank: {x1.varValue}')
        print(f'Hours worked by Paul: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
