
from gurobipy import *

try:
    # Create a new model
    m = Model("optimization_problem")

    # Create variables
    cafeteria_chairs = m.addVar(vtype=GRB.INTEGER, name="cafeteria_chairs")
    red_highlighters = m.addVar(vtype=GRB.INTEGER, name="red_highlighters")
    mechanical_pencils = m.addVar(vtype=GRB.INTEGER, name="mechanical_pencils")
    printers_3D = m.addVar(vtype=GRB.INTEGER, name="3D_printers")


    # Set objective
    m.setObjective(7*cafeteria_chairs**2 + 6*cafeteria_chairs*red_highlighters + 2*cafeteria_chairs*mechanical_pencils + 4*cafeteria_chairs*printers_3D + 2*red_highlighters**2 + 4*red_highlighters*mechanical_pencils + 1*red_highlighters*printers_3D + 3*mechanical_pencils**2 + 1*mechanical_pencils*printers_3D + 8*printers_3D**2 + 9*cafeteria_chairs + 3*red_highlighters + 1*mechanical_pencils + 5*printers_3D, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*cafeteria_chairs + 4*red_highlighters + 11*mechanical_pencils + 10*printers_3D <= 100, "c0")
    m.addConstr(10*cafeteria_chairs + 9*red_highlighters + 12*mechanical_pencils + 2*printers_3D <= 113, "c1")
    # ... (rest of the constraints as derived from the JSON representation)

    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
