
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="cafeteria_chairs", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="red_highlighters", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="mechanical_pencils", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="3D_printers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7*x0**2 + 6*x0*x1 + 2*x0*x2 + 4*x0*x3 + 2*x1**2 + 4*x1*x2 + x1*x3 + 3*x2**2 + x2*x3 + 8*x3**2 + 9*x0 + 3*x1 + x2 + 5*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x0 + 4*x1 + 11*x2 + 10*x3 <= 100)
    model.addConstr(10*x0 + 9*x1 + 12*x2 + 2*x3 <= 113)
    model.addConstr(x0 + x1 >= 15)
    model.addConstr(x0 + x3 >= 12)
    model.addConstr(x2 + x3 >= 18)
    model.addConstr(x1 + x2 + x3 >= 15)
    model.addConstr(x0 + x1 + x3 >= 15)
    model.addConstr(x0 + x1 + x2 >= 15)
    model.addConstr(x0**2 + x2**2 + x3**2 >= 15)
    model.addConstr(x1 + x2 + x3 >= 22)
    model.addConstr(x0 + x1 + x3 >= 22)
    model.addConstr(x0 + x1 + x2 >= 22)
    model.addConstr(x0**2 + x2**2 + x3**2 >= 22)
    model.addConstr(x1**2 + x2**2 + x3**2 >= 12)
    model.addConstr(x0 + x1 + x3 >= 12)
    model.addConstr(x0 + x1 + x2 >= 12)
    model.addConstr(x0**2 + x2**2 + x3**2 >= 12)
    model.addConstr(x1 + x2 + x3 >= 16)
    model.addConstr(x0 + x1 + x3 >= 16)
    model.addConstr(x0 + x1 + x2 >= 16)
    model.addConstr(x0 + x2 + x3 >= 16)
    model.addConstr(x0**2 + x3**2 >= 20)
    model.addConstr(x0 + x1 + x3 >= 25)
    model.addConstr(x0 + x2 + x3 >= 25)
    model.addConstr(x1**2 + x2**2 + x3**2 >= 25)
    model.addConstr(x0**2 + x1**2 + x3**2 >= 15)
    model.addConstr(x0**2 + x2**2 + x3**2 >= 15)
    model.addConstr(x1**2 + x2**2 + x3**2 >= 15)
    model.addConstr(x0 + x1 + x3 >= 14)
    model.addConstr(x0 + x2 + x3 >= 14)
    model.addConstr(x1 + x2 + x3 >= 14)
    model.addConstr(x1**2 + x2**2 <= 74)
    model.addConstr(x1**2 + x3**2 <= 92)
    model.addConstr(x0 + x1 + x2 + x3 <= 92)
    model.addConstr(x1 + x3 <= 30)
    model.addConstr(x0 + x1 <= 30)
    model.addConstr(x0 + x1 + x3 <= 102)
    model.addConstr(x0**2 + x1**2 + x2**2 <= 48)
    model.addConstr(x1**2 + x2**2 + x3**2 <= 61)
    model.addConstr(x0 + x1 + x2 + x3 <= 61)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Cafeteria chairs: ", x0.varValue)
        print("Red highlighters: ", x1.varValue)
        print("Mechanical pencils: ", x2.varValue)
        print("3D printers: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
