
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
pickles = m.addVar(lb=0, name="pickles")
strawberries = m.addVar(lb=0, name="strawberries")
black_beans = m.addVar(lb=0, name="black_beans")
potatoes = m.addVar(lb=0, name="potatoes")
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks")


# Set objective function
m.setObjective(6.3 * pickles + 6.29 * strawberries + 2.38 * black_beans + 6.52 * potatoes + 9.02 * chicken_drumsticks, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10.42 * potatoes + 13.09 * chicken_drumsticks >= 44)
m.addConstr(1.7 * strawberries + 13.09 * chicken_drumsticks >= 41)
m.addConstr(13.28 * pickles + 1.7 * strawberries >= 41)
m.addConstr(1.7 * strawberries + 5.62 * black_beans >= 30)
m.addConstr(1.7 * strawberries + 10.42 * potatoes >= 44)
m.addConstr(5.62 * black_beans + 13.09 * chicken_drumsticks >= 25)
m.addConstr(13.28 * pickles + 1.7 * strawberries + 5.62 * black_beans + 10.42 * potatoes + 13.09 * chicken_drumsticks >= 25)
m.addConstr(2.77 * black_beans + 4.78 * chicken_drumsticks >= 51)
m.addConstr(2.77 * black_beans + 7.77 * potatoes >= 118)
m.addConstr(7.77 * potatoes + 4.78 * chicken_drumsticks >= 57)
m.addConstr(7.04 * pickles + 2.38 * strawberries >= 134)
m.addConstr(7.04 * pickles + 2.77 * black_beans >= 60)
m.addConstr(7.04 * pickles + 2.38 * strawberries + 7.77 * potatoes >= 86)
m.addConstr(2.38 * strawberries + 2.77 * black_beans + 7.77 * potatoes >= 86)
m.addConstr(7.04 * pickles + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 86)
m.addConstr(2.77 * black_beans + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 86)
m.addConstr(7.04 * pickles + 2.38 * strawberries + 7.77 * potatoes >= 116)
m.addConstr(2.38 * strawberries + 2.77 * black_beans + 7.77 * potatoes >= 116)
m.addConstr(7.04 * pickles + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 116)
m.addConstr(2.77 * black_beans + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 116)
m.addConstr(7.04 * pickles + 2.38 * strawberries + 7.77 * potatoes >= 108)
m.addConstr(2.38 * strawberries + 2.77 * black_beans + 7.77 * potatoes >= 108)
m.addConstr(7.04 * pickles + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 108)
m.addConstr(2.77 * black_beans + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 108)
m.addConstr(7.04 * pickles + 2.38 * strawberries + 7.77 * potatoes >= 84)
m.addConstr(2.38 * strawberries + 2.77 * black_beans + 7.77 * potatoes >= 84)
m.addConstr(7.04 * pickles + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 84)
m.addConstr(2.77 * black_beans + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 84)
m.addConstr(7.04 * pickles + 2.38 * strawberries + 2.77 * black_beans + 7.77 * potatoes + 4.78 * chicken_drumsticks >= 84)
m.addConstr(4.32 * strawberries + 14.84 * potatoes >= 78)
m.addConstr(11.37 * pickles + 5.79 * black_beans >= 130)
m.addConstr(11.37 * pickles + 4.32 * strawberries >= 136)
m.addConstr(4.32 * strawberries + 11.88 * chicken_drumsticks >= 157)
m.addConstr(4.32 * strawberries + 5.79 * black_beans >= 165)
m.addConstr(11.37 * pickles + 14.84 * potatoes >= 63)
m.addConstr(11.37 * pickles + 4.32 * strawberries + 11.88 * chicken_drumsticks >= 162)
m.addConstr(11.37 * pickles + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 162)
m.addConstr(4.32 * strawberries + 5.79 * black_beans + 11.88 * chicken_drumsticks >= 162)
m.addConstr(5.79 * black_beans + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 162)
m.addConstr(11.37 * pickles + 4.32 * strawberries + 11.88 * chicken_drumsticks >= 149)
m.addConstr(11.37 * pickles + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 149)
m.addConstr(4.32 * strawberries + 5.79 * black_beans + 11.88 * chicken_drumsticks >= 149)
m.addConstr(5.79 * black_beans + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 149)
m.addConstr(11.37 * pickles + 4.32 * strawberries + 11.88 * chicken_drumsticks >= 134)
m.addConstr(11.37 * pickles + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 134)
m.addConstr(4.32 * strawberries + 5.79 * black_beans + 11.88 * chicken_drumsticks >= 134)
m.addConstr(5.79 * black_beans + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 134)
m.addConstr(11.37 * pickles + 4.32 * strawberries + 11.88 * chicken_drumsticks >= 150)
m.addConstr(11.37 * pickles + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 150)
m.addConstr(4.32 * strawberries + 5.79 * black_beans + 11.88 * chicken_drumsticks >= 150)
m.addConstr(5.79 * black_beans + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 150)
m.addConstr(11.37 * pickles + 4.32 * strawberries + 5.79 * black_beans + 14.84 * potatoes + 11.88 * chicken_drumsticks >= 150)
m.addConstr(5.04 * pickles + 10.92 * strawberries >= 32)
m.addConstr(14.17 * black_beans + 14.27 * potatoes >= 53)
m.addConstr(5.04 * pickles + 6.07 * chicken_drumsticks >= 53)
m.addConstr(5.04 * pickles + 14.17 * black_beans >= 20)
m.addConstr(10.92 * strawberries + 14.27 * potatoes >= 25)
m.addConstr(10.92 * strawberries + 14.17 * black_beans >= 37)
m.addConstr(10.92 * strawberries + 6.07 * chicken_drumsticks >= 38)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 14.27 * potatoes >= 28)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 14.27 * potatoes >= 28)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 28)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 28)
m.addConstr(5.04 * pickles + 10.92 * strawberries + 14.17 * black_beans >= 28)
m.addConstr(5.04 * pickles + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 28)
m.addConstr(14.17 * black_beans + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 28)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 14.27 * potatoes >= 51)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 14.27 * potatoes >= 51)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 51)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 51)
m.addConstr(5.04 * pickles + 10.92 * strawberries + 14.17 * black_beans >= 51)
m.addConstr(5.04 * pickles + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 51)
m.addConstr(14.17 * black_beans + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 51)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 14.27 * potatoes >= 53)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 14.27 * potatoes >= 53)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 53)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 53)
m.addConstr(5.04 * pickles + 10.92 * strawberries + 14.17 * black_beans >= 53)
m.addConstr(5.04 * pickles + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 53)
m.addConstr(14.17 * black_beans + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 53)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 14.27 * potatoes >= 44)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 14.27 * potatoes >= 44)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 44)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 44)
m.addConstr(5.04 * pickles + 10.92 * strawberries + 14.17 * black_beans >= 44)
m.addConstr(5.04 * pickles + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 44)
m.addConstr(14.17 * black_beans + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 44)

m.addConstr(5.04 * pickles + 14.17 * black_beans + 14.27 * potatoes >= 32)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 14.27 * potatoes >= 32)
m.addConstr(5.04 * pickles + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 32)
m.addConstr(10.92 * strawberries + 14.17 * black_beans + 6.07 * chicken_drumsticks >= 32)
m.addConstr(5.04 * pickles + 10.92 * strawberries + 14.17 * black_beans >= 32)
m.addConstr(5.04 * pickles + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 32)
m.addConstr(14.17 * black_beans + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 32)
m.addConstr(5.04 * pickles + 10.92 * strawberries + 14.17 * black_beans + 14.27 * potatoes + 6.07 * chicken_drumsticks >= 32)


m.addConstr(7 * pickles - 6 * black_beans >= 0)
m.addConstr(13.28 * pickles + 10.42 * potatoes <= 138)
m.addConstr(1.7 * strawberries + 13.09 * chicken_drumsticks <= 196)
m.addConstr(13.28 * pickles + 5.62 * black_beans <= 108)
m.addConstr(13.28 * pickles + 1.7 * strawberries <= 131)
m.addConstr(5.62 * black_beans + 13.09 * chicken_drumsticks <= 152)
m.addConstr(7.77 * potatoes + 4.78 * chicken_drumsticks <= 157)
m.addConstr(2.38 * strawberries + 7.77 * potatoes <= 534)
m.addConstr(2.77 * black_beans + 7.77 * potatoes <= 273)
m.addConstr(2.38 * strawberries + 4.78 * chicken_drumsticks <= 500)
m.addConstr(7.04 * pickles + 2.38 * strawberries + 2.77 * black_beans <= 513)
m.addConstr(2.38 * strawberries + 7.77 * potatoes + 4.78 * chicken_drumsticks <= 359)
m.addConstr(2.77 * black_beans + 7.77 * potatoes + 4.78 * chicken_drumsticks <= 144)
m.addConstr(2.38 * strawberries + 2.77 * black_beans + 7.77 * potatoes <= 