
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(lb=0, name="steaks")
black_beans = m.addVar(lb=0, name="black_beans")
potatoes = m.addVar(lb=0, name="potatoes")
knishes = m.addVar(lb=0, name="knishes")


# Set objective function
m.setObjective(4 * steaks + 1 * black_beans + 8 * potatoes + 6 * knishes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6.37 * steaks + 4.49 * black_beans + 4.69 * potatoes + 6.31 * knishes <= 336, "c0")
m.addConstr(6.47 * steaks + 5.58 * black_beans + 6.75 * potatoes + 3.47 * knishes <= 354, "c1")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 0.72 * potatoes + 6.41 * knishes <= 590, "c2")
m.addConstr(4.49 * black_beans + 6.31 * knishes >= 65, "c3")
m.addConstr(6.37 * steaks + 6.31 * knishes >= 70, "c4")
m.addConstr(6.37 * steaks + 4.49 * black_beans >= 81, "c5")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 6.31 * knishes >= 60, "c6")
m.addConstr(6.37 * steaks + 4.69 * potatoes + 6.31 * knishes >= 60, "c7")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 4.69 * potatoes >= 60, "c8")
m.addConstr(4.49 * black_beans + 4.69 * potatoes + 6.31 * knishes >= 60, "c9")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 6.31 * knishes >= 54, "c10")
m.addConstr(6.37 * steaks + 4.69 * potatoes + 6.31 * knishes >= 54, "c11")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 4.69 * potatoes >= 54, "c12")
m.addConstr(4.49 * black_beans + 4.69 * potatoes + 6.31 * knishes >= 54, "c13")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 6.31 * knishes >= 53, "c14")
m.addConstr(6.37 * steaks + 4.69 * potatoes + 6.31 * knishes >= 53, "c15")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 4.69 * potatoes >= 53, "c16")
m.addConstr(4.49 * black_beans + 4.69 * potatoes + 6.31 * knishes >= 53, "c17")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 6.31 * knishes >= 62, "c18")
m.addConstr(6.37 * steaks + 4.69 * potatoes + 6.31 * knishes >= 62, "c19")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 4.69 * potatoes >= 62, "c20")
m.addConstr(4.49 * black_beans + 4.69 * potatoes + 6.31 * knishes >= 62, "c21")
m.addConstr(6.37 * steaks + 4.49 * black_beans + 4.69 * potatoes + 6.31 * knishes >= 62, "c22")
m.addConstr(5.58 * black_beans + 6.75 * potatoes >= 35, "c23")
m.addConstr(6.47 * steaks + 3.47 * knishes >= 41, "c24")
m.addConstr(6.47 * steaks + 5.58 * black_beans + 6.75 * potatoes + 3.47 * knishes >= 41, "c25")
m.addConstr(5.74 * steaks + 6.93 * black_beans >= 136, "c26")
m.addConstr(5.74 * steaks + 6.41 * knishes >= 127, "c27")
m.addConstr(5.74 * steaks + 0.72 * potatoes >= 65, "c28")
m.addConstr(0.72 * potatoes + 6.41 * knishes >= 95, "c29")
m.addConstr(6.93 * black_beans + 0.72 * potatoes >= 108, "c30")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 0.72 * potatoes >= 126, "c31")
m.addConstr(6.93 * black_beans + 0.72 * potatoes + 6.41 * knishes >= 126, "c32")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 6.41 * knishes >= 126, "c33")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 0.72 * potatoes >= 127, "c34")
m.addConstr(6.93 * black_beans + 0.72 * potatoes + 6.41 * knishes >= 127, "c35")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 6.41 * knishes >= 127, "c36")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 0.72 * potatoes >= 101, "c37")
m.addConstr(6.93 * black_beans + 0.72 * potatoes + 6.41 * knishes >= 101, "c38")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 6.41 * knishes >= 101, "c39")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 0.72 * potatoes + 6.41 * knishes >= 101, "c40")
m.addConstr(7 * black_beans - knishes >= 0, "c41")
m.addConstr(6.37 * steaks + 4.69 * potatoes <= 254, "c42")
m.addConstr(6.37 * steaks + 4.49 * black_beans <= 293, "c43")
m.addConstr(6.47 * steaks + 5.58 * black_beans + 6.75 * potatoes <= 246, "c44")
m.addConstr(5.74 * steaks + 6.93 * black_beans + 0.72 * potatoes <= 162, "c45")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", m.status)

