
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")
    bobby_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
    paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")


    # Set objective function
    model.setObjective(6.18 * mary_hours + 2.63 * bobby_hours + 1.35 * paul_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13 * mary_hours + 5 * bobby_hours + 11 * paul_hours >= 18, "c0")
    model.addConstr(14 * mary_hours + 11 * bobby_hours >= 19, "c1")
    model.addConstr(14 * mary_hours + 5 * paul_hours >= 41, "c2")
    model.addConstr(-2 * bobby_hours + 7 * paul_hours >= 0, "c3")
    model.addConstr(5 * bobby_hours + 11 * paul_hours <= 67, "c4")
    model.addConstr(13 * mary_hours + 5 * bobby_hours + 11 * paul_hours <= 67, "c5")
    model.addConstr(14 * mary_hours + 5 * paul_hours <= 96, "c6")
    model.addConstr(14 * mary_hours + 11 * bobby_hours <= 160, "c7")
    model.addConstr(14 * mary_hours + 11 * bobby_hours + 5 * paul_hours <= 159, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Mary Hours: %g' % mary_hours.x)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
