
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul

    # Objective function
    model.setObjective(6.18*x0 + 2.63*x1 + 1.35*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x0 + 5*x1 + 11*x2 >= 18)
    model.addConstr(14*x0 + 11*x1 >= 19)
    model.addConstr(14*x0 + 5*x2 >= 41)
    model.addConstr(-2*x1 + 7*x2 >= 0)
    model.addConstr(5*x1 + 11*x2 <= 67)
    model.addConstr(13*x0 + 5*x1 + 11*x2 <= 67)
    model.addConstr(14*x0 + 5*x2 <= 96)
    model.addConstr(14*x0 + 11*x1 <= 160)
    model.addConstr(14*x0 + 11*x1 + 5*x2 <= 159)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x0.varValue}")
        print(f"Hours worked by Bobby: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
