
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="granola_bars")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bananas")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")

# Set objective function
m.setObjective(9*x0 + 5*x1 + 9*x2 + 3*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 8*x2 >= 49)
m.addConstr(4*x0 + 4*x1 + 8*x2 + 14*x3 >= 49)
m.addConstr(26*x0 + 19*x2 >= 66)
m.addConstr(26*x0 + 21*x1 >= 115)
m.addConstr(19*x2 + 6*x3 >= 70)
m.addConstr(26*x0 + 6*x3 >= 107)
m.addConstr(21*x1 + 6*x3 >= 75)
m.addConstr(26*x0 + 21*x1 + 19*x2 + 6*x3 >= 75)
m.addConstr(-x0 + x1 >= 0)
m.addConstr(5*x1 - 9*x3 >= 0)
m.addConstr(8*x2 + 14*x3 <= 183)
m.addConstr(4*x0 + 8*x2 <= 197)
m.addConstr(4*x1 + 14*x3 <= 67)
m.addConstr(4*x0 + 4*x1 + 14*x3 <= 83)
m.addConstr(26*x0 + 6*x3 <= 375)
m.addConstr(21*x1 + 19*x2 <= 459)
m.addConstr(19*x2 + 6*x3 <= 270)
m.addConstr(26*x0 + 21*x1 + 19*x2 <= 268)
m.addConstr(21*x1 + 19*x2 + 6*x3 <= 264)
m.addConstr(26*x0 + 19*x2 + 6*x3 <= 273)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

