
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # granola bars
    x1 = model.addVar(name="x1")  # bananas
    x2 = model.addVar(name="x2")  # rotisserie chickens
    x3 = model.addVar(name="x3")  # bowls of pasta

    # Objective function
    model.setObjective(9 * x0 + 5 * x1 + 9 * x2 + 3 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 + 4 * x1 + 8 * x2 + 14 * x3 <= 250)
    model.addConstr(26 * x0 + 21 * x1 + 19 * x2 + 6 * x3 <= 487)
    model.addConstr(4 * x1 + 8 * x2 >= 49)
    model.addConstr(4 * x0 + 4 * x1 + 8 * x2 + 14 * x3 >= 49)
    model.addConstr(26 * x0 + 19 * x2 >= 66)
    model.addConstr(26 * x0 + 21 * x1 >= 115)
    model.addConstr(19 * x2 + 6 * x3 >= 70)
    model.addConstr(26 * x0 + 6 * x3 >= 107)
    model.addConstr(21 * x1 + 6 * x3 >= 75)
    model.addConstr(26 * x0 + 21 * x1 + 19 * x2 + 6 * x3 >= 75)
    model.addConstr(-x0 + x1 >= 0)
    model.addConstr(5 * x1 - 9 * x3 >= 0)
    model.addConstr(8 * x2 + 14 * x3 <= 183)
    model.addConstr(4 * x0 + 8 * x2 <= 197)
    model.addConstr(4 * x1 + 14 * x3 <= 67)
    model.addConstr(4 * x0 + 4 * x1 + 14 * x3 <= 83)
    model.addConstr(26 * x0 + 6 * x3 <= 375)
    model.addConstr(21 * x1 + 19 * x2 <= 459)
    model.addConstr(19 * x2 + 6 * x3 <= 270)
    model.addConstr(26 * x0 + 19 * x2 <= 268)
    model.addConstr(21 * x1 + 19 * x2 + 6 * x3 <= 264)
    model.addConstr(26 * x0 + 19 * x2 + 6 * x3 <= 273)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0 (granola bars): ", x0.varValue)
        print("x1 (bananas): ", x1.varValue)
        print("x2 (rotisserie chickens): ", x2.varValue)
        print("x3 (bowls of pasta): ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
