
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    bacon = m.addVar(vtype=GRB.CONTINUOUS, name="strips_of_bacon")
    green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")

    # Set objective function
    m.setObjective(7*bacon**2 + 8*bacon*green_beans + 6*green_beans**2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.27*bacon + 7.15*green_beans >= 62, "fiber_min")
    m.addConstr(1.27*bacon + 7.15*green_beans <= 127, "fiber_max")
    m.addConstr(1.27*bacon**2 + 7.15*green_beans**2 >= 62, "fiber_squared_min")
    m.addConstr(1.62*bacon + 10.55*green_beans >= 24, "iron_min")
    m.addConstr(1.62*bacon + 10.55*green_beans <= 101, "iron_max")
    m.addConstr(1.62*bacon**2 + 10.55*green_beans**2 >= 24, "iron_squared_min")
    m.addConstr(11.41*bacon + 6.62*green_beans >= 28, "calcium_min")
    m.addConstr(11.41*bacon + 6.62*green_beans <= 146, "calcium_max")
    m.addConstr(11.41*bacon**2 + 6.62*green_beans**2 >= 28, "calcium_squared_min")
    m.addConstr(11.41*bacon**2 + 6.62*green_beans**2 <= 126, "calcium_squared_max")
    m.addConstr(4*bacon - 3*green_beans >= 0, "bacon_green_beans_relation")

    # Resource Constraints
    m.addConstr(1.27*bacon <= 157, "fiber_bacon_limit")
    m.addConstr(1.62*bacon <= 122, "iron_bacon_limit")
    m.addConstr(11.41*bacon <= 146, "calcium_bacon_limit")
    m.addConstr(7.15*green_beans <= 157, "fiber_green_beans_limit")
    m.addConstr(10.55*green_beans <= 122, "iron_green_beans_limit")
    m.addConstr(6.62*green_beans <= 146, "calcium_green_beans_limit")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('strips of bacon:', bacon.x)
        print('green beans:', green_beans.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
