
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="strips_of_bacon", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="green_beans", lb=0, ub=gurobi.GRB.INFINITY, integrality=gurobi.GRB.INTEGER)
    
    # Objective function
    model.setObjective(7*x1**2 + 8*x1*x2 + 6*x2**2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(1.27*x1**2 + 7.15*x2**2 >= 62)
    model.addConstr(1.27*x1 + 7.15*x2 >= 62)
    model.addConstr((1.62*x1)**2 + (10.55*x2)**2 >= 24)
    model.addConstr(1.62*x1 + 10.55*x2 >= 24)
    model.addConstr((11.41*x1)**2 + (6.62*x2)**2 >= 28)
    model.addConstr(11.41*x1 + 6.62*x2 >= 28)
    model.addConstr(4*x1 - 3*x2 >= 0)
    model.addConstr(1.27*x1 + 7.15*x2 <= 157)
    model.addConstr(1.62*x1 + 10.55*x2 <= 122)
    model.addConstr(11.41*x1 + 6.62*x2 <= 146)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Strips of bacon: ", x1.varValue)
        print("Green beans: ", x2.varValue)
    else:
        print("No solution found")

optimize_problem()
