
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
apple_trees = m.addVar(vtype=gp.GRB.INTEGER, name="apple_trees")
roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")
peonies = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
coleus = m.addVar(vtype=gp.GRB.INTEGER, name="coleus")
chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")

# Set objective function
m.setObjective(1*apple_trees + 4*roses + 3*peonies + 5*coleus + 4*chili_plants, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*apple_trees + 7*roses + 4*peonies + 9*coleus + 2*chili_plants <= 231, "budget")
m.addConstr(9*apple_trees + 2*chili_plants >= 38, "apple_chili_min")
m.addConstr(9*apple_trees + 7*roses >= 28, "apple_roses_min")
m.addConstr(9*apple_trees + 9*coleus >= 44, "apple_coleus_min")
m.addConstr(4*peonies + 2*chili_plants >= 45, "peonies_chili_min")
m.addConstr(9*apple_trees + 4*peonies >= 27, "apple_peonies_min")
m.addConstr(7*roses + 9*coleus >= 39, "roses_coleus_min")
m.addConstr(9*apple_trees + 7*roses + 4*peonies + 9*coleus + 2*chili_plants >= 39, "total_min")
m.addConstr(7*roses + 4*peonies + 9*coleus <= 87, "roses_peonies_coleus_max")
m.addConstr(4*peonies + 9*coleus + 2*chili_plants <= 169, "peonies_coleus_chili_max")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

