
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='apple_trees', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='roses', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='peonies', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='coleus', vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name='chili_plants', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(x1 + 4*x2 + 3*x3 + 5*x4 + 4*x5, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*x1 + 7*x2 + 4*x3 + 9*x4 + 2*x5 <= 231)
    model.addConstr(9*x1 + 2*x5 >= 38)
    model.addConstr(9*x1 + 7*x2 >= 28)
    model.addConstr(9*x1 + 9*x4 >= 44)
    model.addConstr(4*x3 + 2*x5 >= 45)
    model.addConstr(9*x1 + 4*x3 >= 27)
    model.addConstr(7*x2 + 9*x4 >= 39)
    model.addConstr(9*x1 + 7*x2 + 4*x3 + 9*x4 + 2*x5 >= 39)
    model.addConstr(7*x2 + 4*x3 + 9*x4 <= 87)
    model.addConstr(4*x3 + 9*x4 + 2*x5 <= 169)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Apple trees: ', x1.varValue)
        print('Roses: ', x2.varValue)
        print('Peonies: ', x3.varValue)
        print('Coleus: ', x4.varValue)
        print('Chili plants: ', x5.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
