
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Dale", lb=0)
x2 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x3 = m.addVar(name="hours_worked_by_Paul", lb=0)
x4 = m.addVar(name="hours_worked_by_Mary", lb=0)
x5 = m.addVar(name="hours_worked_by_Hank", lb=0)
x6 = m.addVar(name="hours_worked_by_Ringo", lb=0)
x7 = m.addVar(name="hours_worked_by_George", lb=0)
x8 = m.addVar(name="hours_worked_by_John", lb=0, vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(3*x1*x2 + 5*x1*x5 + 7*x1*x7 + 2*x2**2 + 2*x2*x3 + 3*x4**2 + 8*x4*x5 + 4*x4*x8 + 5*x5*x7 + 4*x5*x8 + 6*x5 + 3*x6 + 6*x8, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(13*x1 <= 1240)
m.addConstr(10*x2 <= 1240)
m.addConstr(16*x3 <= 1240)
m.addConstr(6*x4 <= 1240)
m.addConstr(12*x5 <= 1240)
m.addConstr(12*x6 <= 1240)
m.addConstr(11*x7 <= 1240)
m.addConstr(x8 <= 1240)
m.addConstr(16*x3 + 11*x7 >= 154)
m.addConstr(12*x3 + 12*x6 >= 52)
m.addConstr(11*x7 + x8 >= 95)
m.addConstr(6*x4**2 + 12*x6**2 >= 96)
m.addConstr(12*x6 + x8 >= 68)
m.addConstr(12*x5 + 11*x7 >= 59)
m.addConstr(16*x3 + 12*x5 >= 115)
m.addConstr(x2**2 + x3**2 + x7**2 >= 140)
m.addConstr(x2*x3 + x2*x5 + x3*x7 >= 140)
m.addConstr(x1**2 + x3**2 + x4**2 >= 140)
m.addConstr(x3**2 + x6**2 + x8**2 >= 140)
m.addConstr(x3*x4 + x4*x6 + x6*x8 >= 140)

# ... Add the rest of the constraints

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
    print("Hours worked by Paul: ", x3.varValue)
    print("Hours worked by Mary: ", x4.varValue)
    print("Hours worked by Hank: ", x5.varValue)
    print("Hours worked by Ringo: ", x6.varValue)
    print("Hours worked by George: ", x7.varValue)
    print("Hours worked by John: ", x8.varValue)
else:
    print("The model is infeasible.")
