
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, names=['automatic alerts', 'network administrators', 'system administrators', 'intrusion analysts', 'patches per day'])


# Set objective function
m.setObjective(5.43 * x[0] + 6.09 * x[1] + 6.75 * x[2] + 7.06 * x[3] + 7.38 * x[4], gp.GRB.MINIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 634, 'coefficients': [1.27, 3.74, 3.5, 1.06, 1.38]},
    'r1': {'upper_bound': 502, 'coefficients': [1.0, 0.81, 3.66, 4.84, 5.75]},
    'r2': {'upper_bound': 449, 'coefficients': [4.15, 1.93, 0.86, 5.98, 0.59]}
}

for resource, data in resource_constraints.items():
    m.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(5)) <= data['upper_bound'], name=resource)


m.addConstr(x[0] + x[1] >= 83)
m.addConstr(x[2] + x[3] >= 44)
m.addConstr(x[1] + x[4] >= 61)
m.addConstr(x[2] + x[4] >= 42)
m.addConstr(x[0] + x[4] >= 86)
m.addConstr(x[1] + x[2] >= 82)
m.addConstr(x[3] + x[4] >= 78)
m.addConstr(x[0] + x[2] >= 106)
m.addConstr(x[0] + x[3] >= 78)
m.addConstr(x[0] + x[1] + x[2] + x[3] + x[4] >= 78)
m.addConstr(0.81 * x[1] + 4.84 * x[3] >= 74)
m.addConstr(1.0 * x[0] + 5.75 * x[4] >= 66)
m.addConstr(0.81 * x[1] + 3.66 * x[2] >= 84)
m.addConstr(1.0 * x[0] + 0.81 * x[1] >= 75)
m.addConstr(1.0 * x[0] + 0.81 * x[1] + 3.66 * x[2] + 4.84 * x[3] + 5.75 * x[4] >= 75)
m.addConstr(4.15 * x[0] + 1.93 * x[1] >= 60)
m.addConstr(5.98 * x[3] + 0.59 * x[4] >= 85)
m.addConstr(1.93 * x[1] + 0.86 * x[2] >= 43)
m.addConstr(0.86 * x[2] + 0.59 * x[4] >= 77)
m.addConstr(4.15 * x[0] + 5.98 * x[3] >= 32)
m.addConstr(1.93 * x[1] + 0.86 * x[2] + 0.59 * x[4] >= 73)
m.addConstr(4.15 * x[0] + 1.93 * x[1] + 0.86 * x[2] + 5.98 * x[3] + 0.59 * x[4] >= 73)
m.addConstr(-3 * x[0] + 8 * x[1] >= 0)
m.addConstr(1.27 * x[0] + 3.74 * x[1] + 1.06 * x[3] <= 588)
m.addConstr(1.27 * x[0] + 3.74 * x[1] + 1.38 * x[4] <= 293)
m.addConstr(1.0 * x[0] + 3.66 * x[2] + 4.84 * x[3] <= 360)
m.addConstr(4.15 * x[0] + 5.98 * x[3] <= 406)
m.addConstr(4.15 * x[0] + 1.93 * x[1] + 0.86 * x[2] <= 312)
m.addConstr(1.93 * x[1] + 5.98 * x[3] + 0.59 * x[4] <= 107)
m.addConstr(0.86 * x[2] + 5.98 * x[3] + 0.59 * x[4] <= 366)
m.addConstr(4.15 * x[0] + 0.86 * x[2] + 0.59 * x[4] <= 212)
m.addConstr(1.93 * x[1] + 0.86 * x[2] + 5.98 * x[3] <= 342)
m.addConstr(1.93 * x[1] + 0.86 * x[2] + 0.59 * x[4] <= 125)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

