
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hydrangeas = m.addVar(vtype=GRB.INTEGER, name="hydrangeas")
aloe_vera = m.addVar(vtype=GRB.INTEGER, name="aloe_vera")


# Set objective function
m.setObjective(hydrangeas**2 + 5*hydrangeas + 9*aloe_vera, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*hydrangeas + 26*aloe_vera >= 52, "resilience_lower_bound")
m.addConstr(27*hydrangeas + 19*aloe_vera >= 45, "cost_lower_bound")
m.addConstr(-8*hydrangeas**2 + 5*aloe_vera**2 >= 0, "quadratic_constraint")
m.addConstr(3*hydrangeas + 26*aloe_vera <= 120, "resilience_upper_bound")
m.addConstr(27*hydrangeas**2 + 19*aloe_vera**2 <= 172, "cost_upper_bound")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Hydrangeas: {hydrangeas.x}")
    print(f"Aloe Vera: {aloe_vera.x}")
    print(f"Objective Value: {m.objVal}")

