
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hydrangeas")
x2 = m.addVar(vtype=GRB.INTEGER, name="aloe vera")

# Set objective function
m.setObjective(x1**2 + 5*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 26*x2 >= 52, "Resilience_Index_Min")
m.addConstr(27*x1 + 19*x2 >= 45, "Cost_Min")
m.addConstr(-8*x1**2 + 5*x2**2 >= 0, "Squared_Terms_Constraint")
m.addConstr(3*x1 + 26*x2 <= 120, "Resilience_Index_Max")
m.addConstr(27*x1**2 + 19*x2**2 <= 172, "Cost_Squared_Terms_Max")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
