
import gurobi

def optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="hydrangeas", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="aloe_vera", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1*x1**2 + 5*x1 + 9*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x1 + 26*x2 >= 52, name="resilience_index_min")
    model.addConstr(27*x1 + 19*x2 >= 45, name="cost_min")
    model.addConstr(-8*x1**2 + 5*x2**2 >= 0, name="non_linear_constraint")
    model.addConstr(3*x1 + 26*x2 <= 120, name="resilience_index_max")
    model.addConstr(27*x1 + 19*x2 <= 172, name="cost_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hydrangeas: {x1.varValue}")
        print(f"Aloe Vera: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
