
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
    vitamin_b7 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
    vitamin_e = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")

    # Set objective function
    m.setObjective(8*calcium + 4*vitamin_b7 + 4*vitamin_e + 3*iron, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.19*calcium + 0.59*vitamin_b7 >= 11, "c1")
    m.addConstr(1.19*calcium + 1.6*iron >= 5, "c2")
    m.addConstr(0.59*vitamin_b7 + 1.6*iron >= 11, "c3")
    m.addConstr(0.59*vitamin_b7 + 0.62*vitamin_e + 1.6*iron >= 13, "c4")
    m.addConstr(1.19*calcium + 0.59*vitamin_b7 + 0.62*vitamin_e + 1.6*iron >= 13, "c5")
    m.addConstr(1.01*vitamin_b7 + 2.0*vitamin_e >= 11, "c6")
    m.addConstr(2.0*vitamin_e + 1.04*iron >= 18, "c7")
    m.addConstr(1.01*vitamin_b7 + 1.04*iron >= 10, "c8")
    m.addConstr(0.89*calcium + 1.01*vitamin_b7 + 1.04*iron >= 17, "c9")
    m.addConstr(0.89*calcium + 2.0*vitamin_e + 1.04*iron >= 17, "c10")
    m.addConstr(0.89*calcium + 1.01*vitamin_b7 + 1.04*iron >= 17, "c11")
    m.addConstr(0.89*calcium + 2.0*vitamin_e + 1.04*iron >= 17, "c12")
    m.addConstr(0.89*calcium + 1.01*vitamin_b7 + 2.0*vitamin_e + 1.04*iron >= 17, "c13")
    m.addConstr(-vitamin_b7 + 6*iron >= 0, "c14")
    m.addConstr(6*vitamin_b7 - 10*vitamin_e >= 0, "c15")
    m.addConstr(0.59*vitamin_b7 + 0.62*vitamin_e + 1.6*iron <= 24, "c16")


    # Resource Constraints
    m.addConstr(1.19*calcium <= 63, "rc1")
    m.addConstr(0.89*calcium <= 77, "rc2")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('calcium:', calcium.x)
        print('vitamin_b7:', vitamin_b7.x)
        print('vitamin_e:', vitamin_e.x)
        print('iron:', iron.x)

    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
