
import gurobi

def optimize():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="calcium", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="vitamin_B7", vtype=gurobi.GRB.CONTINUOUS, lb=0)
    x3 = model.addVar(name="vitamin_E", vtype=gurobi.GRB.CONTINUOUS, lb=0)
    x4 = model.addVar(name="iron", vtype=gurobi.GRB.CONTINUOUS, lb=0)

    # Objective function
    model.setObjective(8*x1 + 4*x2 + 4*x3 + 3*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.19*x1 <= 63)
    model.addConstr(0.89*x1 <= 77)
    model.addConstr(0.59*x2 <= 63)
    model.addConstr(1.01*x2 <= 77)
    model.addConstr(0.62*x3 <= 63)
    model.addConstr(2.0*x3 <= 77)
    model.addConstr(1.6*x4 <= 63)
    model.addConstr(1.04*x4 <= 77)
    model.addConstr(1.19*x1 + 0.59*x2 >= 11)
    model.addConstr(1.19*x1 + 1.6*x4 >= 5)
    model.addConstr(0.59*x2 + 1.6*x4 >= 11)
    model.addConstr(0.59*x2 + 0.62*x3 + 1.6*x4 >= 13)
    model.addConstr(1.19*x1 + 0.59*x2 + 0.62*x3 + 1.6*x4 >= 13)
    model.addConstr(1.01*x2 + 2.0*x3 >= 11)
    model.addConstr(2.0*x3 + 1.04*x4 >= 18)
    model.addConstr(1.01*x2 + 1.04*x4 >= 10)
    model.addConstr(0.89*x1 + 1.01*x2 + 1.04*x4 >= 17)
    model.addConstr(0.89*x1 + 2.0*x3 + 1.04*x4 >= 17)
    model.addConstr(0.89*x1 + 1.01*x2 + 1.04*x4 >= 17)
    model.addConstr(0.89*x1 + 2.0*x3 + 1.04*x4 >= 17)
    model.addConstr(0.89*x1 + 1.01*x2 + 2.0*x3 + 1.04*x4 >= 17)
    model.addConstr(-x2 + 6*x4 >= 0)
    model.addConstr(6*x2 - 10*x3 >= 0)
    model.addConstr(0.59*x2 + 0.62*x3 + 1.6*x4 <= 24)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Calcium: ", x1.varValue)
        print("Vitamin B7: ", x2.varValue)
        print("Vitamin E: ", x3.varValue)
        print("Iron: ", x4.varValue)
    else:
        print("No optimal solution found")

optimize()
