
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bobby = m.addVar(vtype=GRB.INTEGER, name="bobby")
dale = m.addVar(vtype=GRB.CONTINUOUS, name="dale")
bill = m.addVar(vtype=GRB.CONTINUOUS, name="bill")
mary = m.addVar(vtype=GRB.CONTINUOUS, name="mary")
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")


# Set objective function
m.setObjective(5.69*bobby**2 + 8.61*bobby*dale + 9.3*bobby*ringo + 5.78*dale**2 + 4.35*dale*mary + 5.76*bill**2 + 1.98*bill*ringo + 3.62*bobby + 7.98*dale + 5.22*bill + 9.82*ringo, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*bobby + 20*bill >= 21)
m.addConstr(9*bobby + 20*dale >= 17)
m.addConstr(9*bobby + 14*mary >= 36)
m.addConstr(20*dale**2 + 20*bill**2 >= 36)
m.addConstr(20*dale**2 + 7*ringo**2 >= 25)
m.addConstr(20*bill + 14*mary >= 16)
m.addConstr(3*mary + 18*ringo >= 14)
m.addConstr(4*bobby + 3*mary >= 20)
m.addConstr(14*dale + 2*bill >= 14)
m.addConstr(14*dale + 18*ringo >= 23)
m.addConstr(14*dale + 2*bill + 18*ringo >= 28)
m.addConstr(4*bobby + 14*dale + 3*mary >= 28)
m.addConstr(14*dale + 3*mary + 18*ringo >= 28)
m.addConstr(14*dale + 2*bill + 18*ringo >= 17)
m.addConstr(4*bobby + 14*dale + 3*mary >= 17)
m.addConstr(14*dale + 3*mary + 18*ringo >= 17)
m.addConstr(14*dale + 2*bill + 18*ringo >= 20)
m.addConstr(4*bobby**2 + 14*dale**2 + 3*mary**2 >= 20)
m.addConstr(14*dale + 3*mary + 18*ringo >= 20)
m.addConstr(5*bill + 16*mary >= 31)
m.addConstr(9*bobby**2 + 16*mary**2 >= 38)
m.addConstr(9*bobby + 19*dale >= 15)
m.addConstr(9*bobby + 5*bill >= 28)
m.addConstr(9*bobby + 11*ringo >= 38)
m.addConstr(19*dale + 16*mary + 11*ringo >= 20)
m.addConstr(9*bobby + 19*dale + 5*bill >= 20)
m.addConstr(5*bill**2 + 16*mary**2 + 11*ringo**2 >= 20)
m.addConstr(9*bobby + 5*bill + 11*ringo >= 20)
m.addConstr(19*dale + 5*bill + 16*mary >= 20)
m.addConstr(19*dale**2 + 16*mary**2 + 11*ringo**2 >= 33)
m.addConstr(9*bobby + 19*dale + 5*bill >= 33)
m.addConstr(5*bill + 16*mary + 11*ringo >= 33)
m.addConstr(9*bobby + 5*bill + 11*ringo >= 33)
m.addConstr(19*dale + 5*bill + 16*mary >= 33)
m.addConstr(19*dale + 16*mary + 11*ringo >= 25)
m.addConstr(9*bobby + 19*dale + 5*bill >= 25)
m.addConstr(5*bill + 16*mary + 11*ringo >= 25)
m.addConstr(9*bobby + 5*bill + 11*ringo >= 25)
m.addConstr(19*dale**2 + 5*bill**2 + 16*mary**2 >= 25)
m.addConstr(19*dale + 16*mary + 11*ringo >= 27)
m.addConstr(9*bobby + 19*dale + 5*bill >= 27)
m.addConstr(5*bill + 16*mary + 11*ringo >= 27)
m.addConstr(9*bobby**2 + 5*bill**2 + 11*ringo**2 >= 27)
m.addConstr(19*dale + 5*bill + 16*mary >= 27)
m.addConstr(19*dale + 16*mary + 11*ringo >= 26)
m.addConstr(9*bobby + 19*dale + 5*bill >= 26)
m.addConstr(5*bill + 16*mary + 11*ringo >= 26)
m.addConstr(9*bobby + 5*bill + 11*ringo >= 26)
m.addConstr(19*dale + 5*bill + 16*mary >= 26)


m.addConstr(9*bobby**2 + 14*mary**2 <= 168)
m.addConstr(14*mary**2 + 7*ringo**2 <= 99)
m.addConstr(20*dale + 20*bill <= 75)
m.addConstr(20*bill + 7*ringo <= 174)
m.addConstr(9*bobby + 20*dale + 20*bill + 14*mary + 7*ringo <= 174)
m.addConstr(14*dale + 3*mary <= 78)
m.addConstr(2*bill + 18*ringo <= 45)
m.addConstr(4*bobby**2 + 14*dale**2 + 3*mary**2 <= 69)
m.addConstr(4*bobby + 2*bill + 3*mary <= 134)
m.addConstr(4*bobby + 14*dale + 18*ringo <= 163)
m.addConstr(4*bobby**2 + 3*mary**2 + 18*ringo**2 <= 106)
m.addConstr(4*bobby + 14*dale + 2*bill + 3*mary + 18*ringo <= 106)
m.addConstr(16*mary + 11*ringo <= 50)
m.addConstr(19*dale**2 + 16*mary**2 <= 77)
m.addConstr(5*bill + 16*mary <= 191)
m.addConstr(9*bobby**2 + 11*ringo**2 <= 44)
m.addConstr(9*bobby**2 + 5*bill**2 <= 202)
m.addConstr(9*bobby + 19*dale + 16*mary <= 79)
m.addConstr(9*bobby + 19*dale + 5*bill + 16*mary + 11*ringo <= 79)
m.addConstr(14*dale + 8*ringo <= 181)
m.addConstr(20*bobby**2 + 14*dale**2 <= 133)
m.addConstr(20*bill**2 + 19*mary**2 <= 142)
m.addConstr(20*bill + 8*ringo <= 139)
m.addConstr(19*mary + 8*ringo <= 73)
m.addConstr(20*bobby + 8*ringo <= 79)
m.addConstr(20*bobby**2 + 19*mary**2 <= 116)
m.addConstr(20*bobby**2 + 20*bill**2 <= 135)
m.addConstr(14*dale + 20*bill + 8*ringo <= 129)
m.addConstr(14*dale**2 + 20*bill**2 + 19*mary**2 <= 103)
m.addConstr(20*bobby + 14*dale + 8*ringo <= 118)
m.addConstr(20*bobby + 14*dale + 20*bill + 19*mary + 8*ringo <= 118)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
