
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="wooden_pencils")
    x1 = model.addVar(vtype=GRB.INTEGER, name="3D_printers")


    # Set objective function
    model.setObjective(7*x0*x1 + 7*x0 + 7*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8*x0 + 16*x1 >= 15, "c0")
    model.addConstr(17*x0*x0 + 5*x1*x1 >= 17, "c1")
    model.addConstr(2*x0 + 12*x1 >= 45, "c2")
    model.addConstr(2*x0 + 8*x1 >= 22, "c3")
    model.addConstr(-x0*x0 + 9*x1*x1 >= 0, "c4")
    model.addConstr(8*x0 + 16*x1 <= 35, "c5")
    model.addConstr(17*x0 + 5*x1 <= 54, "c6")
    model.addConstr(2*x0*x0 + 12*x1*x1 <= 103, "c7")
    model.addConstr(2*x0 + 8*x1 <= 51, "c8")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('wooden_pencils:', x0.x)
        print('3D_printers:', x1.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
