
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="wooden_pencils")
x1 = m.addVar(vtype=GRB.INTEGER, name="3D_printers")

# Objective function
m.setObjective(7*(x0*x1) + 7*x0 + 7*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(8*x0 + 16*x1 >= 15, "employee_satisfaction_min")
m.addConstr((17*x0)**2 + (5*x1)**2 >= 17, "workplace_safety_squared_min")
m.addConstr(2*x0 + 12*x1 >= 45, "usefulness_rating_min")
m.addConstr(2*x0 + 8*x1 >= 22, "storage_space_min")
m.addConstr(-(x0**2) + 9*(x1**2) >= 0, "non_negative_constraint")
m.addConstr(8*x0 + 16*x1 <= 35, "employee_satisfaction_max")
m.addConstr((17*x0) + (5*x1) <= 54, "workplace_safety_max")
m.addConstr((2*x0)**2 + (12*x1)**2 <= 103, "usefulness_rating_squared_max")
m.addConstr(2*x0 + 8*x1 <= 51, "storage_space_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Wooden Pencils: {x0.x}")
    print(f"3D Printers: {x1.x}")
else:
    print("No optimal solution found")
