
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="wooden_pencils", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="3D_printers", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(7 * x1 * x2 + 7 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(8 * x1 + 16 * x2 >= 15, name="employee_satisfaction_min")
model.addConstr(17 * x1 + 5 * x2 <= 54, name="workplace_safety_max")
model.addConstr(2 * x1 + 12 * x2 >= 45, name="usefulness_rating_min")
model.addConstr(2 * x1 + 8 * x2 >= 22, name="storage_space_min")
model.addConstr(-x1**2 + 9 * x2**2 >= 0, name="mixed_constraint")
model.addConstr(8 * x1 + 16 * x2 <= 35, name="employee_satisfaction_max")
model.addConstr((17 * x1)**2 + (5 * x2)**2 >= 17, name="workplace_safety_squared_min")
model.addConstr(2**2 * x1**2 + 12**2 * x2**2 <= 103, name="usefulness_rating_squared_max")
model.addConstr(2 * x1 + 8 * x2 <= 51, name="storage_space_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Wooden Pencils: ", x1.varValue)
    print("3D Printers: ", x2.varValue)
else:
    print("The model is infeasible")
