
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("kidney_support")

    # Create variables
    calcium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")
    vitamin_a = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
    magnesium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")
    zinc = m.addVar(vtype=gp.GRB.CONTINUOUS, name="zinc")


    # Set objective function
    m.setObjective(7*calcium + 1*vitamin_a + 1*magnesium + 4*zinc, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9*vitamin_a + 1*zinc >= 53, "c1")
    m.addConstr(9*calcium + 1*zinc >= 70, "c2")
    m.addConstr(9*calcium + 6*magnesium + 1*zinc >= 70, "c3")
    m.addConstr(9*calcium + 9*vitamin_a + 6*magnesium >= 70, "c4")
    m.addConstr(9*calcium + 6*magnesium + 1*zinc >= 84, "c5")
    m.addConstr(9*calcium + 9*vitamin_a + 6*magnesium >= 84, "c6")
    m.addConstr(9*calcium + 9*vitamin_a <= 110, "c7")
    m.addConstr(6*magnesium + 1*zinc <= 236, "c8")
    m.addConstr(9*vitamin_a + 1*zinc <= 223, "c9")
    m.addConstr(9*calcium + 9*vitamin_a + 6*magnesium + 1*zinc <= 223, "c10")
    m.addConstr(9*calcium + 9*vitamin_a + 6*magnesium + 1*zinc <= 342, "c11") # Resource constraint


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
